-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("river")
end

function OnThink(self)
  timeDiff = Timer:GetTimeDiff()
  
  if not self.initialized then
    self.initialized = true
	
	  if not self.loaded then
		  self.ascending = false
		  self.descending = false
    end
  end
  
  if self.ascending then
    self.z = self:GetPosition().z 
    local pos = Vision.hkvVec3()
    Citadels.GetFloodPosition("River_flood_1", pos)
    if self.z < 25 then
      --self:IncPosition(0,0,timeDiff*5)
      pos.z = pos.z + timeDiff*5
      Citadels.SetFloodPosition("River_flood_1", pos)
    else
      self.ascending = false
    end   
  end
  
  if self.descending then
    self.z = self:GetPosition().z 
    local pos = Vision.hkvVec3()
    Citadels.GetFloodPosition("River_flood_1", pos)
    if self.z > -150 then
      --self:IncPosition(0,0,-timeDiff*5)
      pos.z = pos.z - timeDiff*5
      Citadels.SetFloodPosition("River_flood_1", pos)
    else
      self.descending = false
    end   
  end
  
end

function OnTrigger(self, source, target)
  if source == "ascend" then
    self.descending = false
    self.ascending = true    
  elseif source == "descend" then
    self.ascending = false  
    self.descending = true
  end  
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    --OnAfterSceneLoaded(self)
    self.loaded = true
    self.ascending = ar:Read()
    self.descending = ar:Read()
  elseif (ar:IsSaving()) then
    ar:Write(self.ascending)
    ar:Write(self.descending)
  end
end
